//
//
//

class SnowMaker extends effects;

var() int MaxFlakes;
var() float SnowDensity;

var int FlakeCount;
var float dropDistance;
var float timer;
var float Droptime;

function Tick(float deltaTime)
 {
 local float distance;
 local int direction;
 local SnowFlake Flake;
 local vector loc;
 local rotator r;
 // spawn a drop if needs be
 if (FlakeCount>=MaxFlakes)
    return;

 timer+=deltaTime;
 if (timer<droptime)
    return;

 // spawn that drop in a random location
 direction=Rand(65535);
 distance=FRand()*CollisionRadius;
 r=RotRand();
 r.Pitch=0;
 r.Roll=0;
 loc=Location+(Normal(Vector(r))*distance);
 Flake=Spawn(class'SnowFlake',,,loc);
 if (Flake==none)
    return;
 timer=0.0;
 Flake.DrawScale=0.75+(FRand()*0.2);
 Flake.Scaleglow=0.1+(FRand()*0.3);
 Flake.master=self;
 Flake.Mass*=(1.0+(Flake.drawScale*3));
 Flake.Velocity=vect(0,0,-8);
 FlakeCount++;
 Flake.textureNum=Rand(3);
 //Chunk.skin=tex[i];
 droptime=1.05-SnowDensity;
 }

function PostBeginPlay()
 {
 local vector start,end,hl,hn;
 local Actor A;
 local bool bFoundFloor;
 super.PostBeginPlay();
 start=Location;
 end=Location+Vect(0,0,-2048);
 do
   {
   A=Trace(hl,hn,end,start);
   if (A==Level)
      {
      bFoundFloor=true;
      dropdistance=VSize(Location-hl);
      }
   else
       {
       start=hl;
       if (A==none || start==end)
          bFoundFloor=true;
       }
   } until (bFoundFloor);

 }

function LoseADrop()
 {
 FlakeCount--;
 }

defaultproperties
{
     MaxFlakes=768
     SnowDensity=108.000000
     bHidden=True
     DrawType=DT_Sprite
     Texture=Texture'Markistan.Skins.SnowMakerIcon'
     Skin=Texture'Markistan.Skins.SnowMakerIcon'
     CollisionRadius=3072.000000
     CollisionHeight=2.000000
     bCollideActors=True
}
